<?php 
$this->load->helper('date'); ?>
<br>
<div class="panel-group" id="accordion">
<?php foreach($students as $key=>$student): ?>
  <div class="panel panel-default">
    <div class="panel-heading">
      <h4 class="panel-title">
        <a data-toggle="collapse" data-parent="#accordion" href="#collapse<?= $key; ?>">
        <?= $student->f_name.' '.$student->l_name; ?>
        </a>
        <div class="pull-right" style="margin-top: -5px;">
          <a class="btn btn-primary btn-sm" data-toggle="collapse" data-parent="#accordion" href="#collapse<?= $key; ?>">
            View Details
          </a>
        </div>
      </h4>
    </div>
    <div id="collapse<?= $key; ?>" class="panel-collapse collapse">
      <div class="panel-body">
        <div class="row">
          <div class="col-sm-1">
            <img src="<?= base_url('uploads/'.$student->profile_img) ?>" class="img-responsive img-thumbnail">
          </div>
          <div class="col-sm-3">
            <p><strong>Name :</strong> <?= $student->f_name.' '.$student->l_name; ?></p>
            <p><strong>Username :</strong> <?= $student->username; ?></p>
            <p><strong>Email :</strong> <?= $student->email; ?></p>
            <p><strong>Phone No. :</strong> <?= $student->phone_no; ?></p>
          </div>
          <div class="col-sm-8">
            <div class="pull-right">
              <?= form_open('subscription/create'); ?>
              <?= hidden_input(array('name'=>'student_id', 'value' => $student->user_ID)); ?>
                <button type="submit" class="btn btn-warning btn-sm" data-toggle="tooltip" data-placement="top" title="" data-original-title="Create New Subscription for this Student.">
                  <span class="glyphicon glyphicon-plus"></span> New Subscription
                </button>
              <?= form_close(); ?>
            </div>
            <table class="table table-hover table-striped">
              <thead>
                <tr>
                  <th>Subscription Pack</th>
                  <th>Valid from</th>
                  <th>Valid Upto</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php
                if( !empty($subscriptions[$key]) ) :
                  foreach ($subscriptions[$key] as $subscription) :
                    $pack_name = '';
                    $valid_from = mdate('%d %F, %Y', strtotime($subscription['parent']->valid_from));
                    $valid_upto = '';

                    foreach ($subscription_packs as $pack) {
                      if($subscription['parent']->subscription_pack_ID == $pack->subscription_pack_ID) {
                        $pack_name = $pack->subscription_pack_name;
                        $duration = $pack->duration - 1;
                        $valid_upto = strtotime("$duration days", strtotime($subscription['parent']->valid_from));
                        $valid_upto = mdate('%d %F, %Y', $valid_upto);
                      }
                    }

                ?>
                <tr>
                  <td><?= $pack_name; ?></td>
                  <td><?= $valid_from; ?></td>
                  <td><?= $valid_upto; ?></td>
                  <td>
                    <div style="width: 40px;">
                      <?= edit_action('subscription',$subscription['parent']->subscription_ID); ?>
                    </div>
                  </td>
                </tr>
                <?php
                  if(!empty($subscription['renewals'])){
                    foreach ($subscription['renewals'] as $renewal) :
                    $pack_name = '(Renewed)';
                    $valid_from = mdate('%d %F, %Y', strtotime($renewal->valid_from));
                    $valid_upto = '';

                    foreach ($subscription_packs as $pack) {
                      if($renewal->subscription_pack_ID == $pack->subscription_pack_ID) {
                        $duration = $pack->duration - 1;
                        $valid_upto = strtotime("$duration days", strtotime($renewal->valid_from));
                        $valid_upto = mdate('%d %F, %Y', $valid_upto);
                      }
                    }

                    ?>
                    <tr>
                      <td><em><?= $pack_name; ?></em></td>
                      <td><?= $valid_from; ?></td>
                      <td><?= $valid_upto; ?></td>
                      <td>
                        <div style="width: 40px;">
                          <?= edit_action('subscription',$renewal->subscription_ID); ?>
                        </div>
                      </td>
                    </tr>
                    <?php
                    endforeach;
                  }
                  endforeach;
                else :
                ?>
                <tr>
                  <td style="text-align: center;" colspan="4"> No subscription packs found.</td>
                </tr>
                <?php 
                endif;
                ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>